// PageBasicInfo.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageBasicInfo.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "DecCtrlClientTypes.h"

// CPageBasicInfo Ի

IMPLEMENT_DYNAMIC(CPageBasicInfo, CDialog)

CPageBasicInfo::CPageBasicInfo(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageBasicInfo::IDD, pParent)
{
	m_iLogonID = -1;
}

CPageBasicInfo::~CPageBasicInfo()
{
}

void CPageBasicInfo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_DECID, m_cboDecID);
	DDX_Control(pDX, IDC_CBO_CARD_ID, m_cboCardID);
	DDX_Control(pDX, IDC_EDT_MASTER_VERSION, m_edtMasterVersion);
	DDX_Control(pDX, IDC_EDT_PROXY_VERSION, m_edtProxyVersion);
	DDX_Control(pDX, IDC_EDT_STREAM_VERSION, m_edtStreamVersion);
	DDX_Control(pDX, IDC_EDT_PRODUCT_MODEL, m_edtProductModel);
	DDX_Control(pDX, IDC_STC_PRODUCT_MODEL, m_stcProductModel);
	DDX_Control(pDX, IDC_STC_MASTER_VERSION, m_stcMasterVersion);
	DDX_Control(pDX, IDC_STC_PROXY_VERSION, m_stcProxyVersion);
	DDX_Control(pDX, IDC_STC_STREAM_VERSION, m_stcStreamVersion);
	DDX_Control(pDX, IDC_EDT_TYPE2, m_edtType2);
	DDX_Control(pDX, IDC_STC_TYPE, m_stcType2);
	DDX_Control(pDX, IDC_EDT_MASTER_VERSION2, m_edtVersion);
	DDX_Control(pDX, IDC_CBO_DECCARD_ID, m_cboDecCardID);
}


BEGIN_MESSAGE_MAP(CPageBasicInfo, CDialog)
	ON_CBN_SELCHANGE(IDC_CBO_CARD_ID, &CPageBasicInfo::OnCbnSelchangeCboCardId)
	ON_CBN_SELCHANGE(IDC_CBO_DECCARD_ID, &CPageBasicInfo::OnCbnSelchangeCboDeccardId)
	ON_CBN_SELCHANGE(IDC_CBO_DECID, &CPageBasicInfo::OnCbnSelchangeCboDecid)
END_MESSAGE_MAP()

void CPageBasicInfo::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STC_DEC_ID, GetText(IDS_DEC_ID));
	SetDlgItemText(IDC_STC_CARD_ID, GetText(IDS_CARD_ID));
	SetDlgItemText(IDC_STC_MASTER_VERSION, GetText(IDS_VERSION));
	SetDlgItemText(IDC_STC_PROXY_VERSION, GetText(IDS_PROXY_VERSION));
	SetDlgItemText(IDC_STC_STREAM_VERSION, GetText(IDS_STREAM_VERSION));
	SetDlgItemText(IDC_STC_PRODUCT_MODEL, GetText(IDS_PRODUCT_MODEL));
	SetDlgItemText(IDC_STC_PRODUCT_MODEL2, GetText(IDS_PRODUCT_MODEL));
	SetDlgItemText(IDC_STC_TYPE, GetText(IDS_TYPE));
}
int CPageBasicInfo:: Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();

	return TRUE;
}

// CPageBasicInfo Ϣ

void CPageBasicInfo::OnCbnSelchangeCboCardId()
{
	UpdateCtrlCardData();
}

void CPageBasicInfo::OnCbnSelchangeCboDeccardId()
{
	UpdateDecoderCardData();
}

void CPageBasicInfo::OnCbnSelchangeCboDecid()
{
	if(m_iLogonID < 0)
	{
		m_iLogonID = 0;
	}
	m_cboCardID.ResetContent();
	m_cboDecCardID.ResetContent();
	ClusterDeviceInfo tClusterDeviceInfo = {0};
	int iResultSize = 0;
	tClusterDeviceInfo.iDevId = m_cboDecID.GetCurSel();
	DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_DEVICE_INFO, &tClusterDeviceInfo, sizeof(ClusterDeviceInfo), &iResultSize);
	for (int i=0; i < tClusterDeviceInfo.iCtrlCardNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboCardID.AddString(strNo);
	}
	m_cboCardID.SetCurSel(0);
	for (int i=0; i < tClusterDeviceInfo.iSlotdNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboDecCardID.AddString(strNo);
	}
	m_cboDecCardID.SetCurSel(0);
	UpdateDecoderCardData();
	UpdateCtrlCardData();
}

BOOL CPageBasicInfo::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	if(m_iLogonID < 0)
	{
		m_iLogonID = 0;
	}
	ClusterInfo tClusterInfo = {0};
	int iResultSize = 0;
	DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_CLUSTERINFO, &tClusterInfo, sizeof(ClusterInfo), &iResultSize);
	for (int i=0; i < tClusterInfo.iDevNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboDecID.AddString(strNo);
	}

	m_cboDecID.SetCurSel(0);
	OnCbnSelchangeCboDecid();
	OnCbnSelchangeCboCardId();
	OnCbnSelchangeCboDecid();
	OnCbnSelchangeCboDeccardId();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPageBasicInfo::UpdateCtrlCardData()
{
	if(m_iLogonID < 0)
	{
		m_iLogonID = 0;
	}
	ClusterControlCardInfo tClusterControlCardInfo = {0};
	int iRet = 0;
	int iResultSize = 0;
	tClusterControlCardInfo.iDevId = m_cboDecID.GetCurSel();
	tClusterControlCardInfo.iCardId = m_cboCardID.GetCurSel();
	if(tClusterControlCardInfo.iCardId < 0)
	{
		return;
	}
	tClusterControlCardInfo.iSize = sizeof(ClusterControlCardInfo);
	iRet = DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_CONTROL_CARD_VERSIONINFO, &tClusterControlCardInfo, sizeof(ClusterControlCardInfo), &iResultSize);
	if(0 == iRet)
	{
		CString cstext;
		cstext.Format("%s", tClusterControlCardInfo.cMasterVersion);
		SetDlgItemText(IDC_EDT_MASTER_VERSION,cstext);
		cstext.Format("%s", tClusterControlCardInfo.cProxyVersion);
		SetDlgItemText(IDC_EDT_PROXY_VERSION, cstext);
		cstext.Format("%s", tClusterControlCardInfo.cStreamVersion);
		SetDlgItemText(IDC_EDT_STREAM_VERSION, cstext);
		cstext.Format("%d", tClusterControlCardInfo.iProductModel);
		SetDlgItemText(IDC_EDT_PRODUCT_MODEL, cstext);
		SetDlgItemText(IDC_EDIT_ONVIF_VERSION, tClusterControlCardInfo.cOnvifVersion);
		SetDlgItemText(IDC_EDIT_MCU_VERSION, tClusterControlCardInfo.cMcuVersion);
	}
}

void CPageBasicInfo::UpdateDecoderCardData()
{
	if(m_iLogonID < 0)
	{
		m_iLogonID = 0;
	}
	ClusterWorkCardInfo tClusterWorkCardInfo = {0};
	int iRet = 0;
	int iResultSize = 0;
	tClusterWorkCardInfo.iDevId = m_cboDecID.GetCurSel();
	tClusterWorkCardInfo.iCardId = m_cboDecCardID.GetCurSel();
	if(tClusterWorkCardInfo.iCardId < 0)
	{
		return;
	}
	tClusterWorkCardInfo.iSize = sizeof(ClusterWorkCardInfo);
	iRet = DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_WORK_CARD_VERSIONINFO, &tClusterWorkCardInfo, sizeof(ClusterWorkCardInfo), &iResultSize);
	if(0 == iRet)
	{
		CString cstext;
		cstext.Format("%s", tClusterWorkCardInfo.cVersion);
		SetDlgItemText(IDC_EDT_MASTER_VERSION2,cstext);

		if(CARD_TYPE_DECODE == tClusterWorkCardInfo.iCardType)
		{
			SetDlgItemText(IDC_EDT_TYPE2, GetText(IDS_DECODE_CARD));
		}
		else if(CARD_TYPE_ENCODE == tClusterWorkCardInfo.iCardType)
		{
			SetDlgItemText(IDC_EDT_TYPE2, GetText(IDS_CODING_CARD));
		}

		cstext.Format("%d", tClusterWorkCardInfo.iProductModel);
		SetDlgItemText(IDC_EDT_PRODUCT_MODEL2,cstext);
		SetDlgItemText(IDC_EDIT_FPGA_IN_VERSION, tClusterWorkCardInfo.cFpgaInVersion);
		SetDlgItemText(IDC_EDIT_FPGA_OUT_VERSION, tClusterWorkCardInfo.cFpgaOutVersion);
	}
}